package cn.com.duiba.projectx.sdk;


import cn.com.duiba.projectx.sdk.data.CreditsParamData;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.data.ProjectWhiteListData;
import cn.com.duiba.projectx.sdk.playway.base.PrizeStock;
import cn.com.duiba.projectx.sdk.timerapis.ComponentTimerApi;
import cn.com.duiba.projectx.sdk.utils.ConfigurationApi;
import cn.com.duiba.projectx.sdk.utils.CreditsApi;
import cn.com.duiba.projectx.sdk.utils.ExpireTime;
import cn.com.duiba.projectx.sdk.utils.Field;
import cn.com.duiba.projectx.sdk.utils.KeyValueApi;
import cn.com.duiba.projectx.sdk.utils.PageList;
import cn.com.duiba.projectx.sdk.utils.PrizeApi;
import cn.com.duiba.projectx.sdk.utils.QueryTable;
import cn.com.duiba.projectx.sdk.utils.StagePropertyApi;
import cn.com.duiba.projectx.sdk.utils.WhiteListApi;

import java.util.Date;
import java.util.List;

/**
 * 定时任务作用域下的API
 *
 * @author xuhengfei
 */
public interface TimerApi extends CommonApi {
    /**
     * 直接发奖，不通过发奖规则进行发奖
     *
     * @param strategyId
     * @param userId
     * @param prizeId
     * @return
     * @see #getPrizeApi()
     * @see PrizeApi#sendPrize(String, String, String)
     * @see PrizeApi#sendPrize(String, String, String, String)
     */
    @Deprecated
    boolean sendPrizeWithDirect(String strategyId, String userId, String prizeId);
    @Deprecated
    boolean sendPrizeWithDirect(String strategyId, String userId, String prizeId, String spPrizeExtra);

    /**
     * 直接发奖，不通过发奖规则进行发奖
     *
     * @param strategyId 策略id
     * @param userId     userId
     * @param prizeId    prizeId
     * @return SendPrizeResult
     * @see #getPrizeApi()
     * @see PrizeApi#sendPrize(String, String, String)
     * @see PrizeApi#sendPrize(String, String, String, String)
     */
    @Deprecated
    SendPrizeResult sendPrize(String strategyId, String userId, String prizeId);
    @Deprecated
    SendPrizeResult sendPrize(String strategyId, String userId, String prizeId, String spPrizeExtra);

    /**
     * 直接给用户增加积分
     * 没有用户中奖记录
     * 如果发放失败则抛运行时异常
     *
     * @param userId      用户id 不能为空
     * @param quantity    积分数量 不能为空
     * @param description 描述，需要定制时通过该参数, 可以为空
     * @see #getCreditsApi()
     * @see CreditsApi#sendCreditsPrize(String, Long, String)
     * @see CreditsApi#sendCreditsPrize(String, Long, String, String)
     */
    @Deprecated
    void sendCreditsPrize(String userId, Long quantity, String description);
    @Deprecated
    void sendCreditsPrize(String userId, Long quantity, String description, String transfer);

    /**
     * 扣积分失败通知
     *
     * @param ticketNum
     * @param transfer  transfer透传参数
     * @see #getCreditsApi()
     * @see CreditsApi#deductCreditsFailNotify(String, String, String)
     */
    @Deprecated
    Boolean deductCreditsFailNotify(String ticketNum, String transfer, String errorMsg);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getIntVariable(String)
     */
    @Deprecated
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量Date
     *
     * @param key 配置项Variable
     * @return 变量对应的Date值
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getDateVariable(String)
     */
    @Deprecated
    Date getDateVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getStringVariable(String)
     */
    @Deprecated
    String getStringVariable(String key);

    /**
     * 获取运营配置变量 image类型
     *
     * @param key
     * @return
     * @see #getConfigurationApi()
     * @see ConfigurationApi#getImageVariable(String)
     */
    @Deprecated
    String getImageVariable(String key);

    /**
     * 获取kv记录
     *
     * @param key
     * @return
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#get(String)}
     */
    @Deprecated
    String getKvStringData(String key);

    /**
     * 添加/更新KV记录
     *
     * @param key
     * @param value
     * @param expireTime
     * @return
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    boolean putKvStringData(String key, String value, Date expireTime);


    /**
     * 增加/减少数值
     *
     * @param key
     * @param offset 增量
     * @param expire 失效时间
     * @return 变更后的数值
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#increase(String, long, ExpireTime)}
     */
    @Deprecated
    long increase(String key, long offset, Date expire);


    /**
     * 获取kv中的数值
     *
     * @param key
     * @return 当值不存在时返回null，存在时返回实际数值
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#getLong(String)}
     */
    @Deprecated
    Long getKvLong(String key);


    /**
     * 给用户发放道具
     *
     * @param userId   userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#giveStageProperty(String, String, int)
     * @see StagePropertyApi#giveStageProperty(String, String, int, String)
     */
    @Deprecated
    Long giveStageProperty(String userId, String spId, int quantity);
    @Deprecated
    Long giveStageProperty(String userId, String spId, int quantity, String extra);

    /**
     * 消耗用户道具
     *
     * @param userId
     * @param spId
     * @param quantity
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#consumeStageProperty(String, String, int)
     * @see StagePropertyApi#consumeStageProperty(String, String, int, String)
     */
    @Deprecated
    Boolean consumeStageProperty(String userId, String spId, int quantity);
    @Deprecated
    Boolean consumeStageProperty(String userId, String spId, int quantity, String extra);

    /**
     * 获取用户道具剩余数量
     * @param userId
     * @param spId
     * @return
     * @see #getStagePropertyApi()
     * @see StagePropertyApi#getSomebodyStageProperty(String, String)
     */
    @Deprecated
    Long getSomebodyStageProperty(String userId, String spId);

    /**
     * 获取白名单用户list
     *
     * @param groupId 白名单分组ID
     * @return
     * @see #getWhiteListApi()
     * @see WhiteListApi#getWhitePartnerUserIdListByGroupId(String)
     */
    @Deprecated
    List<String> getWhiteUserIdsByGroup(String groupId);

    /**
     * 获取一个QueryTable实例
     *
     * @param group 数据分组
     * @param clazz 映射类型
     * @param <T>
     * @return
     */
    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);

    /**
     * 获取某个发奖策略下的所有奖项
     *
     * @param strategyId 发奖策略id
     * @return 奖项列表
     * @see #getPrizeApi()
     * @see PrizeApi#queryOptions(String)
     */
    @Deprecated
    List<Option> queryOptions(String strategyId);

    /**
     * 扣减拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口扣减拖管积分
     *
     * @param creditsParamData
     * @return
     * @see #getCreditsApi()
     * @see CreditsApi#subTrustCredits(CreditsParamData)
     */
    @Deprecated
    Boolean subTrustCredits(CreditsParamData creditsParamData);

    /**
     * 增加拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口增加拖管积分
     *
     * @param creditsParamData
     * @return
     * @see #getCreditsApi()
     * @see CreditsApi#addTrustCredits(CreditsParamData)
     */
    @Deprecated
    Boolean addTrustCredits(CreditsParamData creditsParamData);

    /**
     * 查询拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口查询拖管积分
     *
     * @param userId
     * @return
     * @see #getCreditsApi()
     * @see CreditsApi#queryTrustCreditsByConsumerId(String)
     */
    @Deprecated
    Long queryTrustCreditsByConsumerId(String userId);

    /**
     * 获取指定奖品库存信息
     *
     * @return
     * @see #getPrizeApi()
     * @see PrizeApi#getPrizeStock(String)
     */
    @Deprecated
    PrizeStock getPrizeStock(String prizeId);

    /**
     * 获取组件Api
     */
    ComponentTimerApi getComponentTimerApi();

    /**
     * 根据groupId获取白名单用户信息
     *
     * @param groupId
     * @param page
     * @param pageSize
     * @param startId  开始id，包括此id，可以为空
     * @return
     * @see #getWhiteListApi()
     * @see WhiteListApi#pageListWhiteByGroupId(String, int, int, Long)
     */
    @Deprecated
    PageList<ProjectWhiteListData> listWhiteByGroupId(String groupId, int page, int pageSize, Long startId);
}
