package cn.com.duiba.projectx.sdk.component.tmraward.enums;

/**
 * @program: projectx
 * @description: 明日奖励组件 - 领取方式类型枚举
 * @author: Simba
 * @create: 2021-04-27 17:26
 **/
public enum ReceiveTypeEnum {

    ONE(1, "单个领取"),

    MERGE(2, "合并领取"),
    ;

    private int type;

    private String desc;

    ReceiveTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ReceiveTypeEnum toEnum(int type) {
        for (ReceiveTypeEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

