package cn.com.duiba.projectx.sdk.pay.icbcelife;

import java.util.Map;

/**
 * Created by HePeng on 2022/06/13 11:12.
 */
public interface IcbcElifePayApi {

    /**
     * 工行e生活支付，app端
     * @param request
     * @return
     */
    IcbcElifeAppPayResp createIcbcElifeCharge4App(IcbcElifeAppPayReq request);

    /**
     * 工行e生活支付，微信端
     * @param request
     * @return
     */
    IcbcElifeWxPayResp createIcbcElifeCharge4Wx(IcbcElifeWxPayReq request);

    /**
     * 工行e生活支付，回调通知，app端
     * @param notifyUrl
     * @param params
     * @return
     */
    IcbcElifePayNotifyResp orderNotify4App(String notifyUrl, Map<String, String> params);

    /**
     * 工行e生活支付，回调通知，微信端
     * @param notifyUrl
     * @param params
     * @return
     */
    IcbcElifePayNotifyResp orderNotify4Wx(String notifyUrl, Map<String, String> params);

    /**
     * 工行e生活支付，查询订单状态，微信端
     * @param payRecordId
     * @return
     */
    IcbcElifeWxPayQueryResp queryOrderStatus4Wx(Long payRecordId);

    /**
     * 工行e生活支付结果查询
     * @param payRecordId
     * @return
     */
    int queryPayStatus(Long payRecordId);

}
