package cn.com.duiba.projectx.sdk.pay.xib;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Map;

public interface XibPayApi {
    /**
     * 发起支付
     * @param chargeRequest
     * @return
     */
    XibChargeResponse createCharge(XibChargeRequest chargeRequest);

    /**
     * 查询支付记录状态
     * @param payRecordId
     * @return 《支付状态，退款状态》
     */
    Pair<Integer, Integer> queryStatus(Long payRecordId);

    /**
     * 支付通知
     * @param params
     * @return
     * @throws BizRuntimeException
     */
    XibPayNotifyResp orderNotify(Map<String, Object> params) throws BizRuntimeException;

    /**
     * 发起退款
     * @param payRecordId
     * @return
     */
    XibRefundResp refund(Long payRecordId);
}
