package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.SendPrizeResult;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.data.Option4Inner;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecordForCreateTimeData;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecordForUpdateData;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecordNew;
import cn.com.duiba.projectx.sdk.playway.base.Prize;
import cn.com.duiba.projectx.sdk.playway.base.PrizeStock;

import java.util.List;
import java.util.Map;

public interface PrizeApi extends Api {
    /**
     * 根据奖品id获取奖品信息
     * @param prizeId
     * @return
     */
    Prize getPrize(String prizeId);

    /**
     * 根据奖品id列表获取奖品信息列表
     * @param prizeIdList
     * @return
     */
    List<Prize> getPrizeList(List<String> prizeIdList);

    /**
     * 获取某个发奖策略下的所有奖项
     * @param strategyId
     * @return
     */
    List<Option> queryOptions(String strategyId);

    /**
     * 获取某个发奖策略下的所有奖项(内部使用，会暴露中奖概率)
     * @param strategyId
     * @return
     */
    List<Option4Inner> queryOptions4Inner(String strategyId);

    /**
     * 获取某个奖品/奖项的库存数据（如果是奖品则传入奖品id，如果是奖项则传入奖项id）
     * @param prizeId
     * @return
     */
    PrizeStock getPrizeStock(String prizeId);

    /**
     * 获取某个奖品/奖项的剩余库存（如果是奖品则传入奖品id，如果是奖项则传入奖项id）
     * @param prizeId
     * @return
     */
    int getPrizeLeftStock(String prizeId);

    /**
     * 批量获取某些奖品/奖项的库存数据（如果是奖品则传入奖品id，如果是奖项则传入奖项id）
     * @param prizeIdList
     * @return
     */
    List<PrizeStock> listPrizeStock(List<String> prizeIdList);

    /**
     * 批量获取某些奖品/奖项的剩余库存（如果是奖品则传入奖品id，如果是奖项则传入奖项id），并组装map
     * @param prizeIdList
     * @return
     */
    Map<String, Integer> getPrizeLeftStockMap(List<String> prizeIdList);

    /**
     * 直接发奖，不通过发奖规则进行发奖（一般用于定时任务发奖或消息消费发奖，注意，该方法不走发奖规则，所以发奖规则里面的奖项已发库存不会发生变化，慎用）
     * @param strategyId
     * @param userId
     * @param prizeId
     * @return
     */
    SendPrizeResult sendPrize(String strategyId, String userId, String prizeId);
    SendPrizeResult sendPrize(String strategyId, String userId, String prizeId, String spPrizeExtra);

    /**
     * 根据id查询发奖记录
     * @param id
     * @return
     */
    UserPrizeRecordNew getPrizeRecordById(Long id);

    /**
     * 查询某个用户发奖记录（按照创建时间倒序，最多取1000条）
     * @param userId
     * @param ignoreAddCredits 是否忽略加积分（true-忽略）
     * @return
     */
    List<UserPrizeRecordNew> listSomebodyUserPrizeRecord(String userId, boolean ignoreAddCredits);

    /**
     * 查询某个用户发奖记录（按照创建时间倒序，最多取1000条）
     * @param userId
     * @param ignoreAddCredits 是否忽略加积分（true-忽略）
     * @param ignoreSp 是否忽略道具奖品（true-忽略）
     * @return
     */
    List<UserPrizeRecordNew> listSomebodyUserPrizeRecord(String userId, boolean ignoreAddCredits, boolean ignoreSp);

    /**
     * 插入发奖记录
     * @param userId
     * @param record
     */
    void insertUserPrizeRecord(String userId, UserPrizeRecordForCreateTimeData record);

    /**
     * 根据id更新发奖记录
     * @param userId
     * @param record
     * @return
     */
    boolean updateUserPrizeRecordById(String userId, UserPrizeRecordForUpdateData record);
}
