package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import com.alibaba.fastjson.TypeReference;

import java.util.List;
import java.util.Map;

public interface UserDataNewApi extends Api {
    String getUserData(String userId, String key);
    Long getUserDataLong(String userId, String key);
    <T> T getUserDataObject(String userId, String key, TypeReference<T> typeReference);

    Map<String, String> multiGetUserData(List<String> userIdList, String key);
    Map<String, Long> multiGetUserDataLong(List<String> userIdList, String key);
    <T> Map<String, T> multiGetUserDataObject(List<String> userIdList, String key, TypeReference<T> typeReference);

    void putUserData(String userId, String key, String value);
    void putUserData(String userId, String key, String value, ExpireTime expireTime);

    void putUserDataLong(String userId, String key, long value);
    void putUserDataLong(String userId, String key, long value, ExpireTime expireTime);

    <T> void putUserDataObject(String userId, String key, T object);
    <T> void putUserDataObject(String userId, String key, T object, ExpireTime expireTime);
}
