package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2023/8/21 14:35
 */
@Data
public class WxCouponSaveOrUpdateParam implements Serializable {
    
    private static final long serialVersionUID = 4054185207688365963L;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 微信批次名称
     */
    private String stockName;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 总预算，单位分
     */
    private Long maxAmount;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 使用券金额门槛，单位分
     */
    private Long transactionMinimum;

    /**
     * 批次创建时间
     */
    private Date createTime;

    /**
     * 批次状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockStatusEnum#getStatus()
     */
    private String stockStatus;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 可用开始时间
     */
    private Date availableBeginTime;

    /**
     * 可用结束时间
     */
    private Date availableEndTime;

    /**
     * 总库存
     */
    private Long totalNum;
    
}
