package cn.com.duiba.quanyi.center.api.remoteservice.qygoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qygoods.KamiBatchDto;
import cn.com.duiba.quanyi.center.api.param.qygoods.KamiBatchSearchParam;

import java.util.List;

/**
 * 卡密批次包远程服务
 */
@AdvancedFeignClient
public interface RemoteKamiBatchService {
    /**
     * 分页查询
     *
     * @return 卡密批次包
     */
    List<KamiBatchDto> selectPage(KamiBatchSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 参数
     * @return 符合条件的记录数
     */
    Long selectCount(KamiBatchSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动
     */
    KamiBatchDto selectById(Long id);

    /**
     * 创建卡密批次包
     *
     * @param kamiBatchDto 新增的卡密批次包实体
     * @return id
     */
    Long insert(KamiBatchDto kamiBatchDto);

    /**
     * 更新卡密批次包
     *
     * @param kamiBatchDto 更新的卡密批次包实体
     * @return id
     */
    int update(KamiBatchDto kamiBatchDto);
}
