package cn.com.duiba.quanyi.center.api.remoteservice.qygoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qygoods.KamiCodeDto;
import cn.com.duiba.quanyi.center.api.param.qygoods.KamiCodeSearchParam;

import java.util.List;

/**
 * 卡密包远程服务
 */
@AdvancedFeignClient
public interface RemoteKamiCodeService {
    /**
     * 分页查询
     *
     * @return 卡密包
     */
    List<KamiCodeDto> selectPage(KamiCodeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 参数
     * @return 符合条件的记录数
     */
    Long selectCount(KamiCodeSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动
     */
    KamiCodeDto selectById(Long id);

    /**
     * 创建卡密包
     *
     * @param kamiCodeDto 新增的卡密包实体
     * @return id
     */
    Long insert(KamiCodeDto kamiCodeDto);

    /**
     * 更新卡密包
     *
     * @param kamiCodeDto 更新的卡密包实体
     * @return id
     */
    int update(KamiCodeDto kamiCodeDto);
}
