package cn.com.duiba.quanyi.center.api.remoteservice.qygoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qygoods.KamiDto;
import cn.com.duiba.quanyi.center.api.param.qygoods.KamiSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 卡密包远程服务
 */
@AdvancedFeignClient
public interface RemoteKamiService {
    /**
     * 分页查询
     *
     * @return 卡密包
     */
    List<KamiDto> selectPage(KamiSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 参数
     * @return 符合条件的记录数
     */
    Long selectCount(KamiSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动
     */
    KamiDto selectById(Long id);

    /**
     * 创建卡密包
     *
     * @param goodsPkgDto 新增的卡密包实体
     * @return id
     */
    Long insert(KamiDto goodsPkgDto);

    /**
     * 更新卡密包
     *
     * @param goodsPkgDto 更新的卡密包实体
     * @return id
     */
    int update(KamiDto goodsPkgDto);
}
