package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeExtDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeExtSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 奖品配置配置扩展表
 * @author kjj mybatis generator 
 * @date 2023-12-18
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeExtService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 奖品配置配置扩展集合
     */
    List<ActivityPrizeExtDto> selectNoPage(ActivityPrizeExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 奖品配置配置扩展
     */
    ActivityPrizeExtDto selectById(Long id);

    /**
     * 根据奖品id查询扩展信息
     * @param prizeId 主键
     * @return 奖品配置配置扩展
     */
    Map<Integer, String> selectMapByPrizeId(Long prizeId);
}