package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiJointConfigDto;
import cn.com.duiba.quanyi.center.api.param.api.ApiJointConfigSearchParam;

import java.util.List;

/**
 * API供给配置表
 *
 * @author kjj mybatis generator
 * @date 2023-11-30
 */
@AdvancedFeignClient
public interface RemoteApiJointConfigService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return API供给配置集合
     */
    List<ApiJointConfigDto> selectPage(ApiJointConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ApiJointConfigSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return API供给配置
     */
    ApiJointConfigDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto API供给配置
     * @return 执行结果
     */
    Long insert(ApiJointConfigDto dto);

    /**
     * 更新
     *
     * @param dto API供给配置
     * @return 影响行数
     */
    int update(ApiJointConfigDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}