package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.CcbCountCoinsActivityRelationDto;

import java.util.List;
import java.util.Set;

/**
 * 建行数币红包活动关联
 *
 * @author yangyukang
 * @create 2023-09-22 21:11:03
 **/
@AdvancedFeignClient
public interface RemoteCcbCountCoinsActivityRelationService {
    /**
     * 批量新增
     * @param list 建行数币红包关联
     * @return 执行结果
     */
    int batchInsert(List<CcbCountCoinsActivityRelationDto> list);

    /**
     * 批量逻辑删除
     *
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    Integer countByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    List<CcbCountCoinsActivityRelationDto> selectByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据立减金ID批量查询
     *
     * @param activityIds 立减金ID集合
     * @return 建行数币红包活动关联列表
     */
    List<CcbCountCoinsActivityRelationDto> selectByActivityIds(Set<Long> activityIds);
}
