package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动奖品领取记录
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeReceiveRecordDto implements Serializable {

    private static final long serialVersionUID = 1983166690426515826L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 订单号
     */
    @Deprecated
    private String bizOrderNo;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    @Deprecated
    private Long demandGoodsId;

    /**
     * 微信立减金主键, tb_wx_coupon.id
     */
    @Deprecated
    private Long wxCouponId;

    /**
     * 微信批次号
     */
    @Deprecated
    private String stockId;

    /**
     * 发券商户ID
     */
    @Deprecated
    private String mchId;

    /**
     * 创建批次的商户号
     */
    @Deprecated
    private String stockCreatorMchId;

    /**
     * 面额，单位分
     */
    @Deprecated
    private Long couponAmount;

    /**
     * 公众账号ID
     */
    @Deprecated
    private String appId;

    /**
     * 收款用户openId
     */
    @Deprecated
    private String openId;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeOrderStatusEnum
     */
    @Deprecated
    private Integer orderStatus;

    /**
     * 领取时间
     */
    @Deprecated
    private Date receiveTime;

    /**
     * 商品库订单号
     */
    @Deprecated
    private String orderNo;

    /**
     * 失败原因
     */
    @Deprecated
    private String errorMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}