package cn.com.duiba.quanyi.center.api.dto.pkg;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品包sku表
 * @author kjj mybatis generator 
 * @date 2023-09-14
 */
@Data
public class GoodsPkgSkuDto implements Serializable {

    private static final long serialVersionUID = 1L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 商品包主键
     */
    private Long goodsPkgId;

    /**
     * 商品库skuID
     */
    private Long skuId;

    /**
     * 商品库spu主键
     */
    private Long spuId;

    /**
     * 商品库spu名称
     */
    private String spuName;

    /**
     * 商品库spu类型
     */
    private Integer spuType;

    /**
     * 商品库供应商id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 指导价，划线价，单位分，比如1元，数据存为100
     */
    private Integer marketPrice;

    /**
     * 建议售价，平台卖价，单位分，比如1元，数据存为100
     */
    private Integer sellPrice;

    /**
     * 商品规格图片
     */
    private String goodsImg;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}