package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付结果状态（展示给C端用户的）
 * @author lizhi
 * @date 2023/8/28 19:53
 */
@Getter
@AllArgsConstructor
public enum ActivityPayResultStatusEnum {
    
    PROCESS(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    CANCEL(4, "取消"),
    REFUNDING(5, "退款中"),
    REFUND_SUCCESS(6, "退款成功"),
    ;

    private final Integer status;

    private final String desc;

    public static ActivityPayResultStatusEnum getByPayStatus(Integer payStatus) {
        ActivityOrderPayStatusEnum statusEnum = ActivityOrderPayStatusEnum.getByCode(payStatus);
        switch (statusEnum) {
            case ORDER_FAIL:
            case PAY_FAIL:
                return ActivityPayResultStatusEnum.FAIL;
            case PAY_SUCCESS:
                return ActivityPayResultStatusEnum.SUCCESS;
            case PAY_REVERSED:
                return ActivityPayResultStatusEnum.CANCEL;
            case REFUND_SUCCESS:
                return ActivityPayResultStatusEnum.REFUND_SUCCESS;
            case REFUNDING:
            case REFUND_FAIL:
                return ActivityPayResultStatusEnum.REFUNDING;
            default:
                return ActivityPayResultStatusEnum.PROCESS;
        }
    }
}
