package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * CREDIT:信用卡
 * DEBIT:借记卡
 * DEBIT_CREDIT:借记卡或信用卡
 *
 * @see <a>https://opendocs.alipay.com/pre-apis/01trl0</>
 */
@Getter
@AllArgsConstructor
public enum AlipayBankCardTypeEnum {
    CREDIT("CREDIT", "信用卡"),
    DEBIT("DEBIT", "借记卡"),
    DEBIT_CREDIT("DEBIT_CREDIT", "借记卡或信用卡"),
    ;

    private final String type;

    private final String desc;
}
