package cn.com.duiba.quanyi.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.SpreadLinkDto;

/**
 * 推广链接表
 * @author lizhi
 * @date 2023/9/19 18:44
 */
@AdvancedFeignClient
public interface RemoteSpreadLinkService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 推广链接
     */
    SpreadLinkDto selectById(Long id);

    /**
     * 根据主键查询
     * @param channelBizType 渠道类型
     * @param channelId 渠道id
     * @return 推广链接
     */
    SpreadLinkDto selectByChannelId(Integer channelBizType,Long channelId);


    /**
     * 新增
     * @param entity 推广链接
     * @return 执行结果
     */
    Long insert(SpreadLinkDto entity);

    /**
     * 更新
     * @param entity 推广链接
     * @return 执行结果
     */
    int update(SpreadLinkDto entity);
}
