package cn.com.duiba.quanyi.center.api.remoteservice.code;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.code.CodeDto;

import java.util.List;

/**
 * 渠道券码表
 * @author lizhi
 * @date 2023/9/20 10:24
 */
@AdvancedFeignClient
public interface RemoteCodeService {

    /**
     * 根据券码查询
     * @param couponCode 券码
     * @return 渠道券码
     */
    CodeDto selectByCode(String couponCode);

    /**
     * 批量插入渠道券码
     * @param codeList 券码列表
     */
    void batchInsert(List<CodeDto> codeList);

    /**
     * 根据业务Id查询
     * @param bizId 业务Id
     * @param codeBizType 业务类型，1-商品包制券
     * @see cn.com.duiba.quanyi.center.api.enums.code.CodeBizTypeEnum
     * @return 券码列表
     */
    List<CodeDto> queryByBizId(Long bizId, Integer codeBizType);

    /**
     * 绑定券码
     * @param userId 用户ID
     * @param codeId 券码Id
     * @return 是否成功
     */
    boolean bind(Long userId, Long codeId);
}
