package cn.com.duiba.quanyi.center.api.remoteservice.code;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 用户渠道券码关联表
 * @author lizhi
 * @date 2023/9/19 20:46
 */
@AdvancedFeignClient
public interface RemoteCodeUserRefService {

    /**
     * 根据用户和业务查询
     * @param userId 用户ID
     * @param codeBizType 业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.code.CodeBizTypeEnum
     * @param codeBizId 业务ID
     * @return 用户渠道券码
     */
    String selectCodeByUserBiz(Long userId, Integer codeBizType, Long codeBizId);
}
