package cn.com.duiba.quanyi.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderDto;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderResultDto;
import cn.com.duiba.quanyi.center.api.param.order.GoodsOrderPageParam;
import cn.com.duiba.wolf.utils.BeanUtils;

import java.util.List;
import java.util.Set;

/**
 * 商品库订单服务
 * @author lizhi
 * @date 2023/9/20 19:02
 */
@AdvancedFeignClient
public interface RemoteGoodsOrderService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品订单
     */
    GoodsOrderDto selectById(Long id);

    /**
     * 根据订单号批量查询
     * @param goodsOrderNos 订单号
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsOrderNos(Set<String> goodsOrderNos);

    /**
     * 批量查询商品订单
     * @param goodsBizType 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     * @param goodsBizIds 商品库订单业务主键
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsBizIds(Integer goodsBizType, List<Long> goodsBizIds);

    /**
     * 查询结果
     * @param goodsOrderNo 商品库下单订单号
     * @return 结果
     */
    GoodsOrderResultDto getResult(String goodsOrderNo);

    /**
     * 根据订单号查询
     * @param goodsOrderNo 订单号
     * @return 商品订单
     */
    GoodsOrderDto selectByGoodsOrderNo(String goodsOrderNo);

    /**
     * 根据业务订单号和业务也行查询  mng后台查询使用
     * @param bizOrderNos
     * @param goodsBizType
     * @return
     */
    List<GoodsOrderDto> selectByBizOrderNoAndBizType(List<String> bizOrderNos, Integer goodsBizType);

    /**
     * 批量查询商品订单
     *
     * @param goodsBizType 商品库订单业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     * @param goodsBizId 商品库订单业务主键
     * @param bizOrderNoPrefix 业务单号前缀
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsBizNoPrefix(Integer goodsBizType, Long goodsBizId, String bizOrderNoPrefix);

    /**
     * 分页查询
     * @param goodsOrderPageParam
     * @return
     */
    List<GoodsOrderDto> selectPage(GoodsOrderPageParam goodsOrderPageParam);

    /**
     * 查询数量
     * @param goodsOrderPageParam
     * @return
     */
    Long selectCount(GoodsOrderPageParam goodsOrderPageParam);
}
