package cn.com.duiba.quanyi.center.api.param.insurance;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/3/4 15:08
 */
@Data
public class InsuranceEquitySearchParam implements Serializable {
    
    private static final long serialVersionUID = -2175986493715233817L;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 审核状态：1-未审核，2-审核通过，3-审核不通过
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityAuditStatusEnum
     */
    private Integer auditStatus;

    /**
     * 验真状态：1-未验真，2-验真通过，3-验真不通过
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityVerifyStatusEnum
     */
    private Integer verifyStatus;
}
