package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/3/4 15:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceLoginAccountSearchParam extends PageQuery implements Serializable {
    
    private static final long serialVersionUID = 4925487799864635965L;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 账号类型：1-超级管理员，2-管理员，3-坐席
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 姓名
     */
    private String accountName;

    /**
     * 机构ID，仅坐席有值，tb_insurance_institution.id
     */
    private Long institutionId;
    
}
