package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:30
 */
@Getter
@AllArgsConstructor
public enum InsuranceFundBizTypeEnum {
    EQUITY_GRANT(1, "权益发放"),
    EQUITY_ADD(2, "权益金额增加"),
    EQUITY_APPEND(3, "权益金额追加"),
    EQUITY_SUB(4, "权益金额减少"),
    CHANGE_GRANT_PHONE(5, "变更发放账号"),
    TAKE_EQUITY(6, "兑换"),
    
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, InsuranceFundBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceFundBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceFundBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
