package cn.com.duiba.quanyi.center.api.remoteservice.channel;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.param.channel.MpQrCodeCreateParam;
import cn.com.duiba.quanyi.center.api.param.channel.MpUrlSchemeGenerateParam;

/**
 * 小程序二维码
 * @author lizhi
 * @date 2023/8/4 14:38
 */
@AdvancedFeignClient
public interface RemoteMpQrCodeService {

    /**
     * 获取小程序二维码，并上传到oss存储
     * @param param 二维码配置
     * @return 上传结果
     */
    String getWxMpCodeUnLimit(MpQrCodeCreateParam param);

    /**
     * 生产url scheme
     * @param param 参数
     * @return 生成的小程序 scheme 码
     */
    String getUrlScheme(MpUrlSchemeGenerateParam param);
}
