package cn.com.duiba.quanyi.center.api.remoteservice.insurance.login;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyStatDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.login.InsuranceLoginAccountDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceLoginAccountSearchParam;
import java.util.List;

/**
 * 保司端-登录账户表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceLoginAccountService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司端-登录账户集合
     */
    List<InsuranceLoginAccountDto> selectPage(InsuranceLoginAccountSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceLoginAccountSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司端-登录账户
     */
    InsuranceLoginAccountDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司端-登录账户
     * @return 执行结果
     */
    Long insert(InsuranceLoginAccountDto dto) throws BizException;

    /**
     * 更新
     * @param dto 保司端-登录账户
     * @return 影响行数
     */
    int update(InsuranceLoginAccountDto dto);


    /**
     * 根据公司ID列表与账号类型，查询保司端-登录账户
     * @param companyIds
     * @param accountType
     * @return
     */
    List<InsuranceLoginAccountDto> selectByCompanyIdsAndAccountType(List<Long> companyIds, Integer accountType);



    /**
     * 根据机构ID列表与账号类型，查询保司端-登录账户
     * @param institutionIds
     * @param accountType
     * @return
     */
    List<InsuranceLoginAccountDto> selectByInstitutionIdsAndAccountType(List<Long> institutionIds, Integer accountType);


    /**
     * 根据条件查询,查询所有登录集合
     * @param param 查询条件
     * @return 保司端-登录账户集合
     */
    List<InsuranceLoginAccountDto> selectListNoPage(InsuranceLoginAccountSearchParam param);
}