package cn.com.duiba.quanyi.center.api.remoteservice.icbc.gd;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.gd.IcbcGdTakeRecordDto;

import java.util.List;

/**
 * 广东工行春节活动领取记录
 * @author kjj mybatis generator 
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteIcbcGdTakeRecordService {

    /**
     * 根据活动和用户查询当天领取记录
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 广东工行春节活动领取记录
     */
    IcbcGdTakeRecordDto selectByActAndUser(Long activityId, Long userId);

    /**
     * 查询当日记录，不存在则新增
     * @param activityId 活动ID
     * @param userId 用户ID
     * @param prizeId 奖品ID
     * @return 广东工行春节活动领取记录
     */
    IcbcGdTakeRecordDto saveIfAbsent(Long activityId, Long userId, Long prizeId);

    /**
     * 查询本周记录，不存在则新增
     * @param activityId 活动ID
     * @param userId 用户ID
     * @param prizeId 奖品ID
     * @return 广东工行春节活动领取记录
     */
    IcbcGdTakeRecordDto saveIfAbsentByWeek(Long activityId, Long userId, Long prizeId);

    /**
     * 查询本周记录 根据多个活动id查询，不存在则新增
     * 目前针对于 有借记卡和信用卡一起的活动，一次只能有一条记录
     * @param activityIds
     * @param activityId
     * @param userId
     * @param prizeId
     * @return
     */
    IcbcGdTakeRecordDto saveIfAbsentByWeekAndMoreActivityId(List<Long> activityIds, Long activityId, Long userId, Long prizeId);

    /**
     * 根据时间维度查询
     * @param activityId
     * @param userId
     * @param takeDay
     * @return
     */
    IcbcGdTakeRecordDto selectByActAndUserAndTakeDay(Long activityId, Long userId, String takeDay);

    /**
     * 根据主键修改活动和奖品id
     * @param id 主键id
     * @param activityId 活动id
     * @param prizeId 奖品id
     * @return
     */
    int updateActivityById(Long id, Long activityId, Long prizeId);
}