package cn.com.duiba.quanyi.center.api.remoteservice.insurance.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.insurance.verify.InsurancePolicyVerifyLogDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsurancePolicyVerifyLogSearchParam;
import java.util.List;

/**
 * 审核记录表
 * @author kjj mybatis generator 
 * @date 2024-03-14
 */
@AdvancedFeignClient
public interface RemoteInsurancePolicyVerifyLogService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 审核记录集合
     */
    List<InsurancePolicyVerifyLogDto> selectPage(InsurancePolicyVerifyLogSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsurancePolicyVerifyLogSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 审核记录
     */
    InsurancePolicyVerifyLogDto selectById(Long id);

    /**
     * 新增
     * @param dto 审核记录
     * @return 执行结果
     */
    int insert(InsurancePolicyVerifyLogDto dto);

    /**
     * 更新
     * @param dto 审核记录
     * @return 影响行数
     */
    int update(InsurancePolicyVerifyLogDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}