package cn.com.duiba.quanyi.center.api.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

import java.util.Objects;

/**
 * @author zzy
 * @create 2023/10/17 20:01
 **/
@ToString
@Getter
@AllArgsConstructor
public enum UserTypeEnum {
    MP_UNIONID(1, "小程序unionId"),
    H5_COUPON_CODE(2, "H5匿名券码用户"),
    OA_OPENID(3, "公众号静默授权openId"),
    CCB_ZJ_HSQ(4, "浙江建行恵省钱对接"),
    CCB_DINGTALK(5, "建行钉钉联合营销钉钉用户"),
    MP_COUPON_CODE(6, "小程序匿名券码用户"),
    OA_COUPON_CODE(7, "公众号匿名券码用户"),
    ICBC_JX(8, "江西工行用户"),
    ALIPAY_USER_ID(9, "支付宝userId"),
    TOURIST_USER(10, "游客"),
    ICBC_GD(11, "广东工行用户"),
    INSURANCE_CUSTOMER(12, "保司权益领取用户"),
    OA_UNION_ID(13, "公众号手动授权unionId"),
    ICBC_SHAANXI(14, "陕西工行用户"),
    ;
    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据type值解析
     *
     * @param type
     * @return
     */
    public static UserTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (UserTypeEnum typeEnum : values()) {
            if (Objects.equals(type, typeEnum.type)) {
                return typeEnum;
            }
        }
        return null;
    }

}
