package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeStoreDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeStoreSearchParam;
import java.util.List;

/**
 * 奖项门店表
 * @author kjj mybatis generator 
 * @date 2024-03-21
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeStoreService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 奖项门店集合
     */
    List<ActivityPrizeStoreDto> selectPage(ActivityPrizeStoreSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityPrizeStoreSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 奖项门店
     */
    ActivityPrizeStoreDto selectById(Long id);

    /**
     * 根据奖项主键查询
     * @param prizeId 奖项主键
     * @return 奖项门店
     */
    List<ActivityPrizeStoreDto> selectByPrizeId(Long prizeId);

    /**
     * 新增
     * @param dto 奖项门店
     * @return 执行结果
     */
    Long insert(ActivityPrizeStoreDto dto);

    /**
     * 批量新增
     * @param list 奖项门店
     * @return 执行结果
     */
    int batchInsert(List<ActivityPrizeStoreDto> list);

    /**
     * 更新
     * @param dto 奖项门店
     * @return 影响行数
     */
    int update(ActivityPrizeStoreDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}