package cn.com.duiba.quanyi.center.api.dto.api;

import cn.com.duiba.quanyi.center.api.enums.api.ApiKmTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/20 16:02
 */
@Data
public class ApiQuerySubOrderResult implements Serializable {
    
    private static final long serialVersionUID = -4081510886642210993L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 子订单号
     */
    private String subOrderNum;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 错误码，业务错误码，一般是业务逻辑的错误码
     */
    private String failCode;

    /**
     * 错误描述
     */
    private String failDesc;

    /**
     * 发放类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 商品类型
     * 
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 链接券-短链
     */
    private String shortUrl;

    /**
     * 失效时间, 时间戳
     */
    private Long expireTime;

    /**
     * 消费时间
     */
    private Long consumeTime;

    /**
     * 交易流水号
     */
    private String transactionId;

    /**
     * 优惠券Id
     */
    private String couponId;

    /**
     * 卡密类型
     * @see ApiKmTypeEnum
     */
    private Integer kmType;

    /**
     * 卡密code
     */
    private String kmCode;

    /**
     * 卡密密码
     */
    private String kmPassword;

    /**
     * 卡密链接
     */
    private String kmLink;

    /**
     * 红包金额
     */
    private String transferAmount;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 更新时间
     */
    private String gmtModified;

    /**
     * 公众号H5静默授权领取链接，微信立减金/到零钱链接券时有值
     */
    private String oaLink;

    /**
     * 小程序H5唤起授权领取链接，微信立减金/到零钱链接券时有值
     */
    private String mpLink;

    /**
     * 小程序AppID，微信立减金/到零钱链接券时有值
     */
    private String mpAppId;

    /**
     * 小程序Path，微信立减金/到零钱链接券时有值
     */
    private String mpPath;

    /**
     * 支付宝领取链接, 支付宝立减金，链接券时有值
     */
    private String alipayLink;


}
