package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/3/4 14:36
 */
@Getter
@AllArgsConstructor
public enum InsuranceEquityStatusEnum {
    NOT_TAKE(1, "未兑换"),
    PART_TAKE(2, "部分兑换"),
    ALL_TAKE(3, "全部兑换");

    public static InsuranceEquityStatusEnum getByStatus(Integer status) {
        for (InsuranceEquityStatusEnum take : InsuranceEquityStatusEnum.values()) {
            if (Objects.equals(take.getStatus(), status)) {
                return take;
            }
        }
        return null;
    }

    private final Integer status;

    private final String desc;
}
