package cn.com.duiba.quanyi.center.api.dto.pay;

import lombok.Data;

import java.io.Serializable;

/**
 * 微信小程序-重新支付
 * @author lizhi
 * @date 2023/8/19 10:37
 */
@Data
public class WxMpOrderRetryPayResultDto implements Serializable {
    
    private static final long serialVersionUID = 6917645541816403697L;

    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;

    /**
     * 时间戳精确到秒
     */
    private Long timeStamp;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 公众号id
     */
    private String appId;

    /**
     * 签名类型需要和下单一致
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;
}
