package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yangyukang
 */
@Data
@ToString
public class CcbCountCoinsActivitySaveOrUpdateParam implements Serializable {


    private static final long serialVersionUID = -6950863293014302551L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 总库存
     */
    private Long totalNum;

    /**
     * 活动id
     */
    private String ccbActId;

    /**
     * 活动id
     */
    private String activityName;

    /**
     * 活动秘钥
     */
    private String ccbActKey;

    /**
     * 面额
     */
    private Long amount;

    /**
     * 满减门槛
     */
    private Long discountReductionThreshold;

    /**
     * 活动总预算值，以分为单位
     */
    private Long totalBudget;

    /**
     * 发放开始时间
     */
    private Date startTime;

    /**
     * 发放结束时间
     */
    private Date endTime;

    /**
     * 活动规则
     */
    private String activityRule;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 活动状态  0 停用 1启用
     */
    private Integer activityStatus;
}
