package cn.com.duiba.quanyi.center.api.remoteservice.icbc.sx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.sx.IcbcSxWriteOffPushRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.icbc.sx.IcbcSxWriteOffPushRecordSearchParam;

import java.util.List;

/**
 * 山西工行权益推送记录
 * @author kjj mybatis generator 
 * @date 2024-01-30
 */
@AdvancedFeignClient
public interface RemoteIcbcSxWriteOffPushRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 山西工行权益推送记录集合
     */
    List<IcbcSxWriteOffPushRecordDto> selectPage(IcbcSxWriteOffPushRecordSearchParam param);

    /**
     * 根据任务ID查询
     *
     * @param taskId 任务ID
     * @return 结果
     */
    List<IcbcSxWriteOffPushRecordDto> selectByTaskId(Long taskId);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(IcbcSxWriteOffPushRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 山西工行权益推送记录
     */
    IcbcSxWriteOffPushRecordDto selectById(Long id);

    /**
     * 根据主键id批量查询
     * @param ids 主键id集合
     * @return 推送记录
     */
    List<IcbcSxWriteOffPushRecordDto> selectByIds(List<Long> ids);

    /**
     * 根据唯一键集合批量查询
     * @param uniqueKeys 唯一键集合
     * @return 推送记录
     */
    List<IcbcSxWriteOffPushRecordDto> selectByUniqueKeys(List<String> uniqueKeys);

    /**
     * 新增
     * @param dto 山西工行权益推送记录
     * @return 执行结果
     */
    int insert(IcbcSxWriteOffPushRecordDto dto);

    /**
     * 更新
     * @param dto 山西工行权益推送记录
     * @return 影响行数
     */
    int update(IcbcSxWriteOffPushRecordDto dto);

    /**
     * 批量新增，并发mq推送--->quanyi_activity_web
     * @param list 推送列表
     * @return 执行结果
     */
    int batchInsertAndPush(List<IcbcSxWriteOffPushRecordDto> list);

    /**
     * 批量更新推送结果
     *
     * @param list 推送结果
     * @return 更新结果
     */
    int batchUpdatePushResult(List<IcbcSxWriteOffPushRecordDto> list);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}