package cn.com.duiba.quanyi.center.api.dto.api;

import cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * API供给配置表
 *
 * @author mybatis generator
 * @date 2023-11-30
 */
@Data
public class ApiJointConfigDto implements Serializable {

    private static final long serialVersionUID = 17013158059038350L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 场景描述
     */
    private String sceneDesc;

    /**
     * 客户id, tb_partner.id
     */
    private Long partnerId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer openIpWhitelist;

    /**
     * IP白名单
     */
    private String ipWhitelist;

    /**
     * sm2公钥
     */
    private String sm2Pubkey;

    /**
     * sm2私钥
     */
    private String sm2Prikey;

    /**
     * sm4秘钥
     */
    private String sm4Secretkey;

    /**
     * 客户sm2公钥
     */
    private String parterSm2Pubkey;

    /**
     * 是否支持批次回退状态，0-不支持，1-支持
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer supportCouponRefund;

    /**
     * 是否订阅快递信息，0-不订阅，1-订阅
     *
     * @see BooleanEnum#getCode()
     */
    private Integer subExpress;

    /**
     * 是否支持数量
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer supportQuantity;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}