package cn.com.duiba.quanyi.center.api.remoteservice.icbc.jx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.jx.IcbcJxOrderRecordDto;
import cn.com.duiba.quanyi.center.api.param.icbc.jx.IcbcJxOrderRecordSearchParam;
import java.util.List;

/**
 * 用户订单记录表
 * @author kjj mybatis generator 
 * @date 2024-01-10
 */
@AdvancedFeignClient
public interface RemoteIcbcJxOrderRecordService {


    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户订单记录
     */
    IcbcJxOrderRecordDto selectById(Long id);

    /**
     * 根据订单号查询
     * @param orderId 订单号
     * @return 用户订单记录
     */
    IcbcJxOrderRecordDto selectByOrderId(String orderId);

    /**
     * 新增
     * @param dto 用户订单记录
     * @return 执行结果
     */
    int insert(IcbcJxOrderRecordDto dto);

    /**
     * 更新
     * @param dto 用户订单记录
     * @return 影响行数
     */
    int update(IcbcJxOrderRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}