package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author lizhi
 * @date 2024/4/1 16:32
 */
@Getter
@AllArgsConstructor
public enum BatchTakeStatusEnum {
    INIT(1, "待发放"),
    PROCESSING(2, "发放中"),
    PART_FAIL(3, "部分发放失败"),
    ALL_FAIL(4, "全部发放失败"),
    ALL_SUCCESS(5, "全部成功"),
    SHORT_URL_INIT(6, "全部待领取"),
    SHORT_URL_PROCESSING(7, "领取中"),
    SHORT_URL_PART_FAIL(8, "部分领取失败"),
    SHORT_URL_ALL_FAIL(9, "全部领取失败"),
    ;
    
    private final Integer code;
    
    private final String desc;
    
    private static final Set<Integer> SHORT_URL_STATUS = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            SHORT_URL_INIT.getCode(), 
            SHORT_URL_PROCESSING.getCode(), 
            SHORT_URL_PART_FAIL.getCode(), 
            SHORT_URL_ALL_FAIL.getCode())));
    
    public static boolean isShortUrlStatus(Integer status) {
        return SHORT_URL_STATUS.contains(status);
    }
}
