package cn.com.duiba.quanyi.center.api.param;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 合同分页查询参数
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ContractPageQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 2285480466331336761L;
    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 创建人id（条件）
     */
    private Long createPersonId;
    /**
     * 合同名称
     */
    private String contractName;
    /**
     * 合同ID 集合我的合同详情定制字段
     */
    private List<Long> ssoUserList;

}
