package cn.com.duiba.quanyi.center.api.dto.wx;

import cn.com.duiba.quanyi.center.api.enums.bill.WxDownloadRecordUploadStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 微信下载记录
 * @author mybatis generator 
 * @date 2024-05-16
 */
@Data
public class WxDownloadRecordDto implements Serializable {
     
    private static final long serialVersionUID = 1715827715821391L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 起始时间
     */
    private LocalDate startDate;

    /**
     * 结束时间
     */
    private LocalDate endDate;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 下载状态 0-下载中 1-下载成功 2-下载失败 3-oss上传成功 4-存储完成
     */
    private Byte downloadStatus;

    /**
     * 账单原始文件oss地址
     */
    private String billOssUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 上传状态
     * @see WxDownloadRecordUploadStatusEnum
     */
    private Integer uploadStatus;
}