package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:06
 */
@Getter
@AllArgsConstructor
public enum InsuranceTakeStatusEnum {
    // 1-已扣减积分，2-积分已全部退回，3-积分部分退回
    TAKE(1, "已扣减积分"),
    REFUND_PART(2, "积分部分退回"),
    REFUND_ALL(3, "积分已全部退回"),
    ;
    
    private final Integer status;
    
    private final String desc;
    
    private static final Map<Integer, InsuranceTakeStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceTakeStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static InsuranceTakeStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
