package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveRecordDto;
import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityAllPrizeReceiveRecordListParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeReceiveRecordListParam;

import java.util.List;
import java.util.Map;

/**
 * 活动奖品领取记录
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeReceiveRecordService {

    /**
     * 根据活动和用户查询
     *
     * @param activityType
     * @param activityId   活动
     * @param userId       用户
     * @return 领取记录列表
     * @see BizActTypeEnum
     */
    List<ActivityPrizeReceiveRecordDto> selectByActivityUserWithType(Integer activityType, Long activityId, Long userId);

    /**
     * 根据奖品、用户查询
     *
     * @param activityType
     * @param activityPrizeId 奖品ID
     * @param userId          用户ID
     * @return 领取记录
     * @see BizActTypeEnum
     */
    ActivityPrizeReceiveRecordDto selectByActivityPrizeUserWithType(Integer activityType, Long activityPrizeId, Long userId);

    /**
     * 批量查询奖品最大领取次数
     *
     * @param userId 用户ID
     * @param activityType 活动类型
     * @param activityPrizeIds 奖品ID集合
     * @return key：奖品ID，value：领取次数
     */
    Map<Long, Integer> selectTakeTimesByPrizeIds(Long userId, Integer activityType, List<Long> activityPrizeIds);

    /**
     * 批量领取记录
     *
     * @param userId 用户ID
     * @param activityType 活动类型
     * @param activityPrizeIds 奖品ID集合
     * @return 每个奖品的最大领取次数
     */
    List<ActivityPrizeReceiveRecordDto> selectByPrizeIds(Long userId, Integer activityType, List<Long> activityPrizeIds);

    /**
     * C端-用户领取记录分页查询
     *
     * @param param 参数
     * @return 领取记录
     */
    List<ActivityPrizeReceiveRecordDto> selectUserRecordListWithParam(ActivityPrizeReceiveRecordListParam param);

    /**
     * 查询多个活动下的用户奖品记录
     * @param param 查询参数
     * @return
     */
    List<ActivityPrizeReceiveRecordDto> selectUserMoreActivityPrizeRecordList(ActivityAllPrizeReceiveRecordListParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动奖品领取记录
     */
    ActivityPrizeReceiveRecordDto selectById(Long id);

    /**
     * 插入领取记录
     * @param activityPrizeReceiveRecordDto dto
     * @return
     */
    Long insert(ActivityPrizeReceiveRecordDto activityPrizeReceiveRecordDto);
}