package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceDayFundSumStatisticsDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceFundAccountChangeRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceFundAccountChangeRecordParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceStatisticsSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 保司资金账户变更记录表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceFundAccountChangeRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司资金账户变更记录
     */
    InsuranceFundAccountChangeRecordDto selectById(Long id);


    /**
     * 根据订单号查询
     * @param bizNo 订单号
     * @return 保司资金账户变更记录
     */
    InsuranceFundAccountChangeRecordDto selectByBizNo(String bizNo);

    /**
     * 根据订单号批量 查询
     * @param insuranceFundAccountChangeRecordParam 查询参数
     * @return 保司资金账户变更记录
     */
    List<InsuranceFundAccountChangeRecordDto> selectByBizNosAndTime(InsuranceFundAccountChangeRecordParam insuranceFundAccountChangeRecordParam);

    /**
     * 查询积分发放情况
     * @param param
     * @return
     */
    List<InsuranceDayFundSumStatisticsDto> selectDayFundStatistics(InsuranceStatisticsSearchParam param);

    /**
     * 根据创建时间查询数据
     * @param startDate
     * @param lastId
     * @param pageSize
     * @param endDate
     * @return
     */
    List<InsuranceFundAccountChangeRecordDto> selectRefundByGmtCreateOffset(Date startDate, Long lastId, Integer pageSize, Date endDate);
}