/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.goods;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum GoodsOrderStatusEnum {
    PROCESS(1, "\u5904\u7406\u4e2d"),
    SUCCESS(2, "\u6210\u529f"),
    FAIL(3, "\u5931\u8d25\uff0c\u65e0\u6cd5\u81ea\u52a8\u91cd\u8bd5\u6210\u529f"),
    EXCEPTION(4, "\u5f02\u5e38"),
    NOT_RECEIVE(5, "\u5f85\u9886\u53d6"),
    FAIL_CAN_RETRY(6, "\u5931\u8d25\uff0c\u81ea\u52a8\u91cd\u8bd5\u53ef\u80fd\u4f1a\u6210\u529f"),
    SHORT_URL_RECEIVE_PROCESS(7, "\u77ed\u94fe\u9886\u53d6\u4e2d"),
    SHORT_URL_RECEIVE_FAIL(8, "\u77ed\u94fe\u9886\u53d6\u5931\u8d25\uff0c\u65e0\u6cd5\u81ea\u52a8\u91cd\u8bd5\u6210\u529f"),
    SHORT_URL_RECEIVE_FAIL_CAN_RETRY(9, "\u77ed\u94fe\u9886\u53d6\u5931\u8d25\uff0c\u81ea\u52a8\u91cd\u8bd5\u53ef\u80fd\u4f1a\u6210\u529f"),
    SHORT_URL_RECEIVE_EXCEPTION(10, "\u77ed\u94fe\u9886\u53d6\u5f02\u5e38"),
    VERIFICATION(11, "\u5df2\u6838\u9500"),
    EXPIRED(12, "\u5df2\u5931\u6548"),
    RECEIVED(13, "\u5df2\u9886\u53d6"),
    REFUND(14, "\u5df2\u9000\u6b3e"),
    UNSHIPPED(51, "\u5f85\u53d1\u8d27"),
    SHIPPED(52, "\u5f85\u6536\u8d27"),
    COMPLETED(53, "\u5df2\u7b7e\u6536"),
    CANCELED(54, "\u5df2\u53d6\u6d88"),
    RETURNED(55, "\u5df2\u9000\u8d27"),
    CLOSE(99, "\u5df2\u5173\u95ed");

    private final Integer status;
    private final String desc;
    private static final Map<Integer, GoodsOrderStatusEnum> ENUM_MAP;
    private static final Set<Integer> SHORT_URL_STATUS_SET;
    private static final Set<Integer> ALREADY_SUCCESS_STATUS_SET;
    private static final Set<Integer> CAN_RETRY_GRANT_STATUS_SET;
    private static final Set<Integer> CAN_RETRY_RECEIVE_STATUS_SET;

    public static GoodsOrderStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    public static boolean isShortUrlStatus(Integer status) {
        if (status == null) {
            return false;
        }
        return SHORT_URL_STATUS_SET.contains(status);
    }

    public static boolean isAlreadySuccessStatus(Integer status) {
        if (status == null) {
            return false;
        }
        return ALREADY_SUCCESS_STATUS_SET.contains(status);
    }

    public static boolean isAlreadyClose(Integer status) {
        return CLOSE.getStatus().equals(status);
    }

    public static boolean canRetryGrant(Integer status) {
        return CAN_RETRY_GRANT_STATUS_SET.contains(status);
    }

    public static boolean canRetryReceive(Integer status) {
        return CAN_RETRY_RECEIVE_STATUS_SET.contains(status);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private GoodsOrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(GoodsOrderStatusEnum.values()).collect(Collectors.toMap(GoodsOrderStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
        SHORT_URL_STATUS_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(NOT_RECEIVE.getStatus(), SHORT_URL_RECEIVE_PROCESS.getStatus(), SHORT_URL_RECEIVE_FAIL.getStatus(), SHORT_URL_RECEIVE_FAIL_CAN_RETRY.getStatus(), SHORT_URL_RECEIVE_EXCEPTION.getStatus())));
        ALREADY_SUCCESS_STATUS_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(GoodsOrderStatusEnum.SUCCESS.status, GoodsOrderStatusEnum.VERIFICATION.status, EXPIRED.getStatus(), RECEIVED.getStatus(), REFUND.getStatus(), UNSHIPPED.getStatus(), SHIPPED.getStatus(), COMPLETED.getStatus(), CANCELED.getStatus(), RETURNED.getStatus())));
        CAN_RETRY_GRANT_STATUS_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(PROCESS.getStatus(), FAIL.getStatus(), EXCEPTION.getStatus(), FAIL_CAN_RETRY.getStatus())));
        CAN_RETRY_RECEIVE_STATUS_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(SHORT_URL_RECEIVE_PROCESS.getStatus(), SHORT_URL_RECEIVE_FAIL_CAN_RETRY.getStatus(), SHORT_URL_RECEIVE_FAIL.getStatus(), SHORT_URL_RECEIVE_EXCEPTION.getStatus())));
    }
}

