package cn.com.duiba.quanyi.center.api.param.bill;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 账单统计表-批次维度
 * @author mybatis generator 
 * @date 2024-03-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillStatisticStockSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17097957325471453L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账单id tb_bill.id
     */
    private Long billId;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 统计日期 yyyy-mm-dd
     */
    private LocalDate curDate;

    /**
     * 核销金额
     */
    private Long writeOffAmount;

    /**
     * 核销笔数
     */
    private Integer writeOffNum;

    /**
     * 退款/退货金额 分
     */
    private Long refundAmount;

    /**
     * 退款/退货笔数
     */
    private Integer refundNum;

    /**
     * 实际核销金额 分
     */
    private Long realWriteOffAmount;

    /**
     * 实际核销笔数
     */
    private Integer realWriteOffNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}