package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 用户访问渠道类型
 * <p>
 * 普通H5：无静默登录，一般适用于APP内
 * <p>
 * 公众号H5：微信公众号静默登录，能够获取到用户OpenId，适用于微信环境（含小程序内）
 * <p>
 * 小程序H5：H5唤起小程序，能够获取到用户小程序OpenId和UnionId，适用于微信内、系统浏览器
 * <p>
 * 小程序Path：直接唤起小程序，能够获取到用户小程序OpenId和UnionId，适合于微信内：小程序跳转小程序、公众号菜单跳转、公众号文章跳转等，APP内唤起微信小程序等
 *
 * @author zzy
 * @create 2023/10/11 17:04
 **/
@Getter
@AllArgsConstructor
public enum VisitChannelTypeEnum {
    H5_NORMAL(1, "普通H5"),
    H5_OA(2, "公众号H5"),
    H5_MP(3, "小程序H5"),
    MP_PATH(4, "小程序Path"),
    H5_OA_MP(5, "公众号H5(小程序包装)"),
    H5_OA_MP_EVOKE_APP(6, "公众号h5(app渠道自动唤端)"),
    ;

    private final Integer type;

    private final String desc;
}
