package cn.com.duiba.quanyi.center.api.remoteservice.bank.hzbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bank.hzbank.HzBankBillTaskDto;
import cn.com.duiba.quanyi.center.api.param.bank.hzbank.HzBankBillTaskSearchParam;

import java.util.List;

/**
 * 账单任务表
 * @author kjj mybatis generator 
 * @date 2024-07-31
 */
@AdvancedFeignClient
public interface RemoteHzBankBillTaskService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 账单任务集合
     */
    List<HzBankBillTaskDto> selectPage(HzBankBillTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(HzBankBillTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 账单任务
     */
    HzBankBillTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 账单任务
     * @return 执行结果
     */
    Long insert(HzBankBillTaskDto dto);

    /**
     * 更新
     * @param dto 账单任务
     * @return 影响行数
     */
    int update(HzBankBillTaskDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}