package cn.com.duiba.quanyi.center.api.dto.wx;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信核销数据统计表
 * @author mybatis generator 
 * @date 2024-06-19
 */
@Data
public class WxWriteOffDataStatisticDto implements Serializable {
     
    private static final long serialVersionUID = 17187862630171873L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 预算金额
     */
    private Long budgetAmount;

    /**
     * 核销金额
     */
    private Long verifiedAmount;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 核销净额
     */
    private Long netVerifiedAmount;

    /**
     * 余额（不含退款)
     */
    private Long balanceExcludingRefund;

    /**
     * 余额（含退款)
     */
    private Long balanceIncludingRefund;

    /**
     * 总应收账款
     */
    private Long totalReceivables;

    /**
     * 已打款金额
     */
    private Long paidAmount;

    /**
     * 统计月份
     */
    private Integer statisticMonth;

    /**
     * 统计类型
     * 0 - 按月
     * 1 - 截止到当前数据
     */
    private Integer statisticType;

    /**
     * 已发放金额
     */
    private Long distributedAmount;

    /**
     * 未发放金额
     * 配置预算 - 已发放金额
     */
    private Long notDistributedAmount;

    /**
     * 总库存数
     */
    private Long totalStockCount;

    /**
     * 已发放数
     */
    private Long grantedCount;

    /**
     * 已核销数
     */
    private Long verifiedCount;

    /**
     * 剩余库存数
     */
    private Long remainingStockCount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}