package cn.com.duiba.quanyi.center.api.remoteservice.equity.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.equity.coupon.EquityCouponDto;

import java.util.List;
import java.util.Set;

/**
 * 权益券表
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@AdvancedFeignClient
public interface RemoteEquityCouponService {

    /**
     * 根据手机号和状态查询权益券数量
     *
     * @param accountPhone 手机号
     * @param states       状态集合
     * @return 权益券数量
     */
    long selectCountByAccountPhoneAndStates(String accountPhone, List<Integer> states);

    /**
     * 根据用户和状态查询权益券数量
     *
     * @param userUnionId 同一类型下，用户唯一标记
     * @param userType 用户类型
     * @see cn.com.duiba.quanyi.center.api.enums.user.UserTypeEnum
     * @param states       状态集合
     * @return 权益券数量
     */
    long selectCountByUserAndStates(String userUnionId, Integer userType, List<Integer> states);

    /**
     * 根据权益ID查询权益券
     *
     * @param equityId 权益ID
     * @return 权益券
     */
    List<EquityCouponDto> selectByEquityId(Long equityId);

    /**
     * 根据手机号分页查询
     *
     * @param accountPhone 手机号
     * @param couponState 券状态
     * @param lastId 最后主键ID
     * @param pageSize 每页数量
     * @return 权益券列表
     */
    List<EquityCouponDto> selectByAccountPhonePage(String accountPhone, Integer couponState, Long lastId, Integer pageSize);

    /**
     * 根据用户分页查询
     *
     * @param userUnionId 同一类型下，用户唯一标记
     * @param userType 用户类型
     * @see cn.com.duiba.quanyi.center.api.enums.user.UserTypeEnum
     * @param couponState 券状态
     * @param lastId 最后主键ID
     * @param pageSize 每页数量
     * @return 权益券列表
     */
    List<EquityCouponDto> selectByUserPage(String userUnionId, Integer userType, Integer couponState, Long lastId, Integer pageSize);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 权益券
     */
    EquityCouponDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键
     * @return 权益券
     */
    List<EquityCouponDto> selectByIds(Set<Long> ids);
}