/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public enum BindMethodEnum {
    NORMAL_BIND(1, "normalbind", "\u5fae\u4fe1\u7aef"),
    ONE_CLICK_BIND(2, "oneclickbind", "\u4e00\u952e\u7ed1\u5361"),
    FAST_BIND(3, "fastbind", "\u7ed1\u5361\u7801");

    private final Integer code;
    private final String method;
    private final String desc;

    public static List<String> parseMethodList(List<Integer> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return codeList.stream().map(t -> {
            BindMethodEnum methodEnum = BindMethodEnum.getByCode(t);
            if (methodEnum == null) {
                return null;
            }
            return methodEnum.getMethod();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static BindMethodEnum getByCode(Integer code) {
        return Arrays.stream(BindMethodEnum.values()).filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMethod() {
        return this.method;
    }

    public String getDesc() {
        return this.desc;
    }

    private BindMethodEnum(Integer code, String method, String desc) {
        this.code = code;
        this.method = method;
        this.desc = desc;
    }
}

